(*  
	Scripting with Merlin Project

	You may incorporate this ProjectWizards sample code into your program(s) without
	restriction.  This ProjectWizards sample code has been provided "AS IS" and the
	responsibility for its operation is yours.  You are not permitted to
	redistribute this ProjectWizards sample code as "ProjectWizards sample code" after having
	made changes.  If you're going to redistribute the code, we require
	that you make it clear that the code was descended from ProjectWizards sample
	code, but that you've made changes.

	Copyright 2016 ProjectWizards, Melle, Germany. All rights reserved.

	This script goes throught all Merlin Project activities, asks for their title, given latest end, given earliest start, assignment, tags and notes and iterates on the variour items. It then outputs related info into a text file in the taskpaper format on the Desktop folder of the user.
	
	
	If need 'given end' and/or 'given start', you need to run the script in a Merlin Project 3.1.8 version
	It won't output actitivies without a title.
	
	Written by Vicky Stamatopoulou
	For ProjectWizards
	April, 2016
*)

---------------------------

property fileEnding : ".taskpaper"
property ScriptIsDone : "You'll find the taskpaper file on your desktop folder!" & return & "Would you like to open that folder now?"
property dialogueTitle : "Export completed! "
property button2 : "Yes, open the Desktop folder"
property button1 : "Not now"

on trimmReturnsOrTabs(aString)
	set oldDelimiter to AppleScript's text item delimiters
	
	set return_text to ""
	repeat with aPara in paragraphs of aString
		if aPara is not "" then
			set mytemp to aPara as text
			if aPara contains tab then
				set AppleScript's text item delimiters to tab
				set mytemp to mytemp's text items
				set AppleScript's text item delimiters to " "
				set mytemp to mytemp as text
				set AppleScript's text item delimiters to oldDelimiter
				
			end if
			if return_text = "" then
				set return_text to mytemp
			else
				set return_text to return_text & " " & mytemp
			end if
		end if
		
	end repeat
	set AppleScript's text item delimiters to oldDelimiter
	return return_text
end trimmReturnsOrTabs


on writeHeader(aFileName, aName)
	-- create the file and write the header information first
	-- contains project name 
	-- new file is located in the user's Desktop folder
	
	
	set theTextRef to ""
	set pos to path to desktop
	
	set pos to pos as string
	set theTextRef to pos & aFileName
	
	try
		set theTextFile to (open for access file theTextRef with write permission)
		set eof of theTextFile to 0
		
		set Header to (aName & ":" & return)
		write Header to theTextFile starting at eof as class utf8
		
		close access theTextFile
		return theTextRef
	on error
		close access theTextFile
		return 0
	end try
end writeHeader

on writeContent(theTextRef, textContent)
	set theTextFile to open for access file theTextRef with write permission
	set Header to (textContent & return)
	
	write Header to theTextFile starting at eof as class utf8
	close access theTextFile
end writeContent



on checkMissingValue(aValue, checkForFalse)
	if checkForFalse then
		if aValue is false then set aValue to ""
	else
		if aValue is missing value then set aValue to ""
	end if
	return aValue
end checkMissingValue


on formDate(aValue)
	tell application "Merlin Project"
		tell aValue
			set ye to year of timestamp
			set mo to (month of timestamp) as integer
			if mo < 10 then set mo to "0" & mo
			set da to day of timestamp
			if da < 10 then set da to "0" & da
		end tell
	end tell
	set aValue to ye & "-" & mo & "-" & da
	return aValue
end formDate

on kamelCase(aString)
	set I to 0
	set aReturnString to ""
	get count of words of aString
	repeat until I is (count of words of aString)
		set I to I + 1
		set aWord to word I of aString
		set aWord to change_firstCharToUppercase(aWord) of me
		set aReturnString to aReturnString & aWord as text
	end repeat
	
	return aReturnString
end kamelCase

on change_firstCharToUppercase(aString)
	
	set the comparison_string to "abcdefghijklmnopqrstuvwxyz"
	set the source_string to "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	
	set new_text to first character of aString
	set x to the offset of new_text in the comparison_string
	
	if x is not 0 then set new_text to (character x of the source_string) as string
	
	try
		set new_text to new_text & characters 2 through -1 of aString
	end try
	return the new_text
	
end change_firstCharToUppercase



tell application "Merlin Project"
	
	set proj to root project of document 1
	set theFileName to title of proj
	-- create a new file to output information into	
	set myfilename to theFileName & fileEnding
	
	set theTextRef to writeHeader(myfilename, theFileName) of me
	
	if theTextRef is not 0 then
		-- collect and insert project Notes
		set aNote to notes of first child activity of proj
		if aNote is not missing value then
			set textContent to (aNote as text)
			writeContent(theTextRef, textContent) of me
		end if
		
		-- get all activities
		set allActivities to child activities of proj
		--iterate in activities
		repeat with act in allActivities
			if (child activities of act is {}) and (title of act is not " ") then
				tell act
					-- collect the title
					set aTitle to title
					set aAssignedRes to assignments
					set aTagsInfo to tags
					try
						set aEndDate to given latest end -- works in 3.1.7
						(*
						set aEndDate to given end -- if using 3.1.8
						*)
					end try
					
					try
						set aStartDate to given earliest start -- works in 3.1.7
						(*
						set aStartDate to given start -- if using 3.1.8
						*)
					end try
					set aNote to notes
					
				end tell
				
				set aTitle to trimmReturnsOrTabs(aTitle) of me
				set textContent to "	- " & aTitle
				
				-- collect the res
				repeat with aItem in aAssignedRes
					if (title of resource of aItem) is not "Default Resource" then
						-- output only real resources
						set aString to kamelCase(title of resource of aItem) of me
						set textContent to textContent & " @" & aString
					end if
				end repeat
				
				-- collect the tags
				repeat with aItem in aTagsInfo
					set aString to kamelCase(title of aItem) of me
					set textContent to textContent & " @" & aString
				end repeat
				
				
				-- form collected start date
				try
					set dateString to formDate(aEndDate) of me
					-- form start date
					
					set textContent to textContent & " @start(" & dateString & ")"
				end try
				
				
				-- form collected due date
				try
					set dateString to formDate(aStartDate) of me
					-- form due date
					
					set textContent to textContent & " @due(" & dateString & ")"
				end try
				
				writeContent(theTextRef, textContent) of me
				
				--insert notes if existing
				if aNote is not missing value then
					set aNote to trimmReturnsOrTabs(aNote) of me
					set textContent to tab & (aNote as text)
					writeContent(theTextRef, textContent) of me
				end if
				
			end if
		end repeat
		activate
		set theDialogue to display dialog ScriptIsDone buttons {button1, button2} with title dialogueTitle default button button2
		if the button returned of theDialogue is button2 then
			tell application "Finder"
				open (path to desktop folder)
				activate
			end tell
		end if
	end if
	
end tell

