(* 	Scripting with Merlin Project

	You may incorporate this ProjectWizards sample code into your program(s) without
	restriction.  This ProjectWizards sample code has been provided "AS IS" and the
	responsibility for its operation is yours.  You are not permitted to
	redistribute this ProjectWizards sample code as "ProjectWizards sample code" after having
	made changes.  If you're going to redistribute the code, we require
	that you make it clear that the code was descended from ProjectWizards sample
	code, but that you've made changes.

	Copyright  2020 ProjectWizards, Melle, Germany. All rights reserved.

	This script splits tasks in progress into two tasks; a completed and a remaining task.
	It handles assignments and absolute updated actual values defined on the task.
	It does not split assignments, milestones or activity groups.
	It won't split tasks which are completed, or not yet started.

    Just select the task you want to split and call this script.
	Version info: 1.0
	Author: Vicky Stamatopoulou
	Date: March 2020
	

*)
----

property howthisworksDialogString : "Please select the activity you would like to split into completed and remaining tasks and restart this script."
property TheActivityDialogString : "The activity "
property isPlannedForDialogString : " is planned for "
property splitinto2DialogString : ". Would you like to split it into completed and remaining work tasks?"
property howMuchLeadDialogString : "How much lead/lag in days would you need? Leave entry blank for zero lead."
property errorDialogString : "This script splits activities in progress having a given work. It cannot split activity groups, assignments, milestones, elements and completed or not yet started activities."
property completedDialogueString : "Nothing to split! Activity already completed. "
property notStartedDialogueString : "Nothing to split! Activity hadn't been started yet. "
property noWorkDialogueString : "Nothing to split! Activity has no given work. "
property milestoneDialogueString : "Nothing to split! Milestone selected. "
property assignmentDialogueString : "Nothing to split! Assignment selected. "
property resourceDialogueString : "Nothing to split! Resource selected. "
property attachmentDialogueString : "Nothing to split! Attachment selected. "

property projectDialogueString : "Nothing to split! Project row selected. "
property groupDialogueString : "Nothing to split! Group row selected. "

global myStrings
set myStrings to {howthisworksDialogString, projectDialogueString, groupDialogueString, assignmentDialogueString, milestoneDialogueString, notStartedDialogueString, completedDialogueString, noWorkDialogueString, resourceDialogueString, attachmentDialogueString}


on reportError(errorNumber)
	global myStrings
	-- errors: 
	-- 1 nothing selected - checked
	-- 2 for project - checked
	-- 3 group - checked
	-- 4 assignment - checked
	-- 5 milestone  - checked	
	-- 6 not started - checked
	-- 7 completed  - checked	
	-- 8 no work  - checked
	-- 9 resource  - checked
	-- 10 attachment  - checked
	
	
	activate
	set displayMessage to ""
	set displayMessage to item (errorNumber) of myStrings
	
	tell application "Merlin Project" to display dialog displayMessage & return & return & errorDialogString buttons {"OK"} default button 1 with icon 0
	quit me
	
end reportError



tell application "Merlin Project"
	
	activate
	set errorStatus to 0
	try
		-- get selection
		set myselection to selection
		
	on error
		-- 1 nothing selected
		
		reportError(1) of me
	end try
	-- get activity information
	
	if errorStatus is 0 then
		
		try
			if class of item 1 of myselection is assignment then
				-- 4 assignment 			
				reportError(4) of me
			end if
		end try
		
		try
			if class of item 1 of myselection is in {information, checklist, file, risk, issue, event} then
				-- 10 attachment 			
				reportError(10) of me
			end if
		end try
		
		try
			if class of item 1 of myselection is child resource then
				-- 9 resource 			
				reportError(9) of me
			end if
		end try
		
		tell item 1 of myselection
			
			set TheLevel to outline level
			set TheActivity to title
			set aMilestone to milestone
			set TheWork to given work
			set TheExpectedWork to expected work
			set TheExpectedDuration to expected duration
			set TheActualWork to actual work -- does not work
			set remainingWork to remaining work
			set theCompleteness to actual completion
			
		end tell
		
		
		if TheLevel is 0 then
			-- 2 project row		
			reportError(2) of me
		end if
		
		
		try
			get aMilestone
			if aMilestone then
				-- 5 milestone				
				reportError(5) of me
			end if
		end try
		
		set TheChildren to child activities of item 1 of myselection
		
		if (count of TheChildren) > 0 then
			-- 3 group 				
			reportError(3) of me
		end if
		
		if TheWork is missing value then
			-- 8 no work		
			reportError(8) of me
		end if
		
		
		if theCompleteness is 1 then
			-- 7 completed
			reportError(7) of me
		end if
		
		
		try
			tell TheActualWork
				set TheActualAmount to amount
				set TheActualUnit to unit
			end tell
			
			if TheActualAmount is not missing value then
				set TheActualStart to actual start of item 1 of myselection
				set TheActualThru to actual complete through of item 1 of myselection
				
			end if
		on error
			-- 6 not started
			reportError(6) of me
		end try
		
		
		set TheResources to resources of assignments of item 1 of myselection
		
		tell TheWork
			set TheAmount to amount
			set TheUnit to unit
		end tell
		
		
		tell remainingWork
			set remainingWorkAmount to amount
			set remainingWorkUnit to unit
		end tell
		
		
		try
			get TheActualWork
			if TheActualAmount is not missing value then set dialogResult to display dialog TheActivityDialogString & "\"" & TheActivity & "\"" & isPlannedForDialogString & TheAmount & " " & TheUnit & splitinto2DialogString & return & return & "Completed amount " & TheActualAmount & " " & TheActualUnit & return & "Remaining amount: " & remainingWorkAmount & " " & remainingWorkUnit buttons {"Cancel", "OK"} default button "OK" cancel button "Cancel" with icon 2
			
			
			if button returned of dialogResult is "OK" then
				
				-- set the unit to days
				set theDurationUnit to derived durations unit of root project of first document
				if theDurationUnit is missing value then set derived durations unit of root project of first document to days
				
				
				-- Prompt for lead/lag
				set TheLead to display dialog howMuchLeadDialogString default answer "" buttons {"OK"} default button 1 with icon 2
				
				set TheLead to text returned of TheLead
				if TheLead is "" then set TheLead to "0d"
				
				-- create completed task
				set TheNewOne to (make new child activity at end of child activities of item 1 of myselection) as specifier
				tell TheNewOne
					
					set title to "part 1"
					
					set given work to {amount:TheActualAmount, unit:TheActualUnit}
					
					set actual start to TheActualStart
					set actual work to {amount:TheActualAmount, unit:TheActualUnit}
					set actual end to TheActualThru
				end tell
				
				-- create remaining task
				set TheNewSec to (make new child activity at end of child activities of item 1 of myselection) as specifier
				tell TheNewSec
					set title to "part 2"
					set given work to {amount:remainingWorkAmount, unit:remainingWorkUnit}
					
				end tell
				
				-- relate activities finish to start
				set TheRelation to depend TheNewSec upon TheNewOne
				-- set lead/lag onto linkage
				set lag of TheRelation to TheLead
				repeat with aRes in TheResources
					tell aRes
						-- do assignements
						try
							assign aRes to TheNewOne
							assign aRes to TheNewSec
						end try
					end tell
				end repeat
			end if
			
			-- restore the calculation unit
			set derived durations unit of root project of first document to theDurationUnit
			
		on error number -128
			--don't do anything		
		end try
		
		
	end if
end tell

