(* 	Scripting with Merlin Project

	You may incorporate this ProjectWizards sample code into your program(s) without
	restriction.  This ProjectWizards sample code has been provided "AS IS" and the
	responsibility for its operation is yours.  You are not permitted to
	redistribute this ProjectWizards sample code as "ProjectWizards sample code" after having
	made changes.  If you're going to redistribute the code, we require
	that you make it clear that the code was descended from ProjectWizards sample
	code, but that you've made changes.

	Copyright 2015-2018 ProjectWizards, Melle, Germany. All rights reserved.
*)

(*
	This script shifts dates by an offset. Depending on how you want to use it, it goes throught all activities of the current project or the current selection and enters an offset on the given planned earliest start date.
	Written by Vicky Stamatopoulou
	For ProjectWizards
	Apr 21, 2015
	last update Nov 12, 2018
	Now handling correctly date and time plus fixed information. 
	
	
	*)
--

---------------------------

property NeedAProjectMessage : "You must have an open project in order to run this script"
property DoAllOrJustTheSelection : "Shall the script shift the complete project or just the selection?"
property EnterAnOffset : "Please enter the offset for shifting all fixed activities in days. For example: 1, -8, 365"
property DoneMessage : "Done, please check results!"


tell application "Merlin Project"
	global inList
	try
		set doc to the first document
	on error
		display dialog NeedAProjectMessage
		set chosenFile to (choose file)
		open chosenFile
		set doc to the first document
	end try
	
	set proj to root project of doc
	
	set TheOffset to display dialog EnterAnOffset default answer ""
	set TheOffset to (text returned of TheOffset) as integer
	set myselection to selection
	set allActivities to myselection
	set TheBehaviour to display dialog DoAllOrJustTheSelection buttons {"Selection", "All"}
	
	if button returned of TheBehaviour is "All" then
		set allActivities to child activities of proj
	end if
	
	set TheCount to count allActivities
	repeat with i from (TheCount) to 1 by -1
		set act to item i of allActivities
		
		tell act
			try
				outline level
				-- handle earlier start
				
				set TheDueDate to given earliest start
				
				if TheDueDate is missing value then
					set TheDueDate to planned start
					set DueFixed to false
				else
					set DueFixed to fixed of TheDueDate
				end if
				
				set TheDueDateMax to given latest start
				set TaskEndDate to given earliest end
				set TaskEndDateMax to given latest end
				
				set TheDueDate to timestamp of TheDueDate
				
				tell application "Finder" to set myDate to TheDueDate + (TheOffset * days)
				set given earliest start to {timestamp:myDate, fixed:DueFixed}
				
				-- handle latest start
				if TheDueDateMax is not missing value then
					set myDate to timestamp of TheDueDateMax
					tell application "Finder" to set myDate to myDate + (TheOffset * days)
					set given latest start of act to {timestamp:myDate, fixed:(fixed of TheDueDateMax)}
					
				end if
				
				
				-- handle earliest end
				if TaskEndDate is not missing value then
					set myDate to timestamp of TaskEndDate
					tell application "Finder" to set myDate to myDate + (TheOffset * days)
					set given earliest end of act to {timestamp:myDate, fixed:fixed of TaskEndDate}
					
				end if
				
				-- handle latest end
				if TaskEndDateMax is not missing value then
					set myDate to timestamp of TaskEndDateMax
					tell application "Finder" to set myDate to myDate + (TheOffset * days)
					set given latest end of act to {timestamp:myDate, fixed:fixed of TaskEndDateMax}
				end if
			end try
		end tell
		
	end repeat
	display dialog DoneMessage
	
end tell